/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.daemon;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.ICommunicationDaemon;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;

public abstract class AbstractDebuggerCommunicationDaemon
implements ICommunicationDaemon {
    protected Object lock = new Object();
    protected ServerSocket serverSocket;
    protected boolean isAlive;
    protected Thread listenerThread;
    private boolean insideChange;

    @Override
    public void init() {
        this.resetSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startListen() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive && this.serverSocket != null) {
                this.startListenThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListen() {
        Object object = this.lock;
        synchronized (object) {
            block15: {
                this.isAlive = false;
                if (this.serverSocket != null) {
                    try {
                        if (!this.serverSocket.isClosed()) {
                            this.serverSocket.close();
                        }
                    }
                    catch (SocketException socketException) {
                        this.serverSocket = null;
                        break block15;
                    }
                    catch (IOException e) {
                        try {
                            Logger.logException("Problem while closing the debugger ServerSocket.", e);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.serverSocket = null;
                        }
                    }
                    this.serverSocket = null;
                }
            }
        }
        try {
            if (this.listenerThread != null) {
                this.listenerThread.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isListening() {
        Object object = this.lock;
        synchronized (object) {
            return this.isAlive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean resetSocket() {
        if (this.insideChange) {
            return true;
        }
        this.stopListen();
        int port = this.getReceiverPort();
        boolean portWasTaken = false;
        try {
            while (port < 65535) {
                try {
                    ServerSocket s = new ServerSocket(port);
                    s.close();
                    AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(this.getDebuggerID());
                    if (port != this.getReceiverPort()) {
                        this.insideChange = true;
                        debuggerConfiguration.setPort(port);
                        if (!portWasTaken) {
                            debuggerConfiguration.save();
                        }
                        this.insideChange = false;
                    }
                    break;
                }
                catch (BindException bindException) {
                    ++port;
                    portWasTaken = true;
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        try {
            Object e = this.lock;
            synchronized (e) {
                this.serverSocket = new ServerSocket(port);
                this.startListen();
                return true;
            }
        }
        catch (BindException bindException) {
            this.handleMultipleBindingError();
            return false;
        }
        catch (IOException e) {
            Logger.logException("Error while restting the socket for the debug requests.", e);
        }
        return false;
    }

    @Override
    public void handleMultipleBindingError() {
        final int port = this.getReceiverPort();
        Logger.log(4, "The debug port " + port + " is in use. Please select a different port for the debugger.");
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                String message = MessageFormat.format(PHPDebugCoreMessages.Port_Error_Message_Message, String.valueOf(port));
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Port_Error_Message_Title, (String)message);
            }
        });
    }

    public abstract int getReceiverPort();

    protected abstract void startConnectionThread(Socket var1);

    @Override
    public abstract String getDebuggerID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListenThread() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive) {
                return;
            }
            this.isAlive = true;
        }
        String port = " - Port: " + (this.serverSocket != null ? String.valueOf(this.serverSocket.getLocalPort()) : "??");
        this.listenerThread = new Thread((Runnable)new ReceiverThread(), "PHP Debugger Daemon Thread " + port);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public static boolean isPortAvailable(int port) {
        ServerSocket tcp = null;
        DatagramSocket udp = null;
        try {
            try {
                tcp = new ServerSocket(port);
                tcp.setReuseAddress(true);
                udp = new DatagramSocket(port);
                udp.setReuseAddress(true);
            }
            catch (IOException iOException) {
                if (udp != null) {
                    udp.close();
                }
                if (tcp != null) {
                    try {
                        tcp.close();
                    }
                    catch (IOException iOException2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (udp != null) {
                udp.close();
            }
            if (tcp != null) {
                try {
                    tcp.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (udp != null) {
            udp.close();
        }
        if (tcp != null) {
            try {
                tcp.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private class ReceiverThread
    implements Runnable {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (AbstractDebuggerCommunicationDaemon.this.isAlive) {
                    Socket socket = AbstractDebuggerCommunicationDaemon.this.serverSocket.accept();
                    socket.setReceiveBufferSize(131072);
                    socket.setSendBufferSize(131072);
                    AbstractDebuggerCommunicationDaemon.this.startConnectionThread(socket);
                }
            }
            catch (IOException e) {
                Object object = AbstractDebuggerCommunicationDaemon.this.lock;
                synchronized (object) {
                    if (AbstractDebuggerCommunicationDaemon.this.isAlive) {
                        Logger.logException("Error while listening to incoming debug requests. Listen thread terminated!", e);
                        AbstractDebuggerCommunicationDaemon.this.isAlive = false;
                    }
                }
            }
        }
    }
}

